#Script para DataJamp

#Rutina de trabajo
setwd("D:/Mis Documentos/Escritorios/CAGALIND/Desktop/Lab. de Ingeniera/DataJamp")

#Paquetes
library(readxl)
library(dplyr)
library(lubridate)
library(tidyverse)
library(xlsx)
library(readr)
library(imputeTS)

#######################
#Internet fijo

#Importacin de datos

#Base 1
fijo_1=read_csv2("Internet fijo/ACCESOS_INTERNET_FIJO_1_0.csv") %>%
  select(-ID_EMPRESA,-EMPRESA,-ID_DEPARTAMENTO,-ID_MUNICIPIO,
         -ID_SEGMENTO,-SEGMENTO,-ID_TECNOLOGIA,-TECNOLOGIA) %>% 
  unite('Fecha',ANNO,TRIMESTRE,sep="-",remove=TRUE) %>% 
  arrange(Fecha) %>% 
  group_by(Fecha,DEPARTAMENTO,MUNICIPIO) %>%
  summarise('Accesos'=sum(ACCESOS,na.rm=T)) %>% 
  ungroup()

#Base 2
fijo_2=read_csv2("Internet fijo/ACCESOS_INTERNET_FIJO_2_2.csv") %>% 
  select(-ID_EMPRESA,-EMPRESA,-ID_DEPARTAMENTO,-ID_MUNICIPIO,
       -ID_SEGMENTO,-SEGMENTO,-VELOCIDAD_EFECTIVA_DOWNSTREAM,
       -VELOCIDAD_EFECTIVA_UPSTREAM,-ID_TECNOLOGIA,-TECNOLOGIA) %>% 
  unite('Fecha',ANNO,TRIMESTRE,sep="-",remove=TRUE) %>% 
  arrange(Fecha) %>% 
  group_by(Fecha,DEPARTAMENTO,MUNICIPIO) %>%
  summarise('Accesos'=sum(ACCESOS,na.rm=T)) %>% 
  ungroup()

#Unin de bases
fijo_total=merge(fijo_1,fijo_2,by=c('Fecha','DEPARTAMENTO',
                           'MUNICIPIO','Accesos'),all=TRUE) %>% 
  unite('Municipio',MUNICIPIO,DEPARTAMENTO,sep="-",remove=TRUE) %>% 
  mutate(Municipio=str_to_title(Municipio)) %>%
  mutate(Municipio=str_replace_all(Municipio,
                                   c(""="a",""="e",""="i",
                                     ""="o",""="u",''='A',
                                     ''='E',''='I',''='O',
                                     ''='U')))
consolidado=fijo_total %>% 
  group_by(Municipio) %>% 
  spread(key=Municipio,value=Accesos) %>% 
  arrange(Fecha)

#Valores nulos
#Municipios borrados: 112 (9.75% del total)
#sum(colMeans(is.na(consolidado))>porcentaje)
#(370*100)/1148
porcentaje=.2 
columnas_a_borrar=which(colMeans(is.na(consolidado))>porcentaje)
consolidado[,columnas_a_borrar]=NULL

#Imputacin de datos faltantes
consolidado_int_fijo=na_kalman(consolidado,model="auto.arima")
rm(list=setdiff(ls(),"consolidado_int_fijo"))

###################
#Telefona fija

#Importar datos
fijo_1=read_csv2("Telefono fijo/TL_LINEAS_3.csv") %>%
  select(-ID_EMPRESA,-EMPRESA,-ID_DEPARTAMENTO,-ID_MUNICIPIO,
         -ID_UBICACION,-UBICACION,-ID_SEGMENTO,-SEGMENTO) %>%
  filter(ANNO>2011) %>% #Porque antes no hay datos regionales
  unite('Fecha',ANNO,TRIMESTRE,sep="-",remove=TRUE) %>% 
  arrange(Fecha) %>% 
  group_by(Fecha,DEPARTAMENTO,MUNICIPIO) %>%
  summarise('Lineas'=sum(LINEAS,na.rm=T)) %>% 
  ungroup() %>% 
  unite('Municipio',MUNICIPIO,DEPARTAMENTO,sep="-",remove=TRUE) %>% 
  mutate(Municipio=str_to_title(Municipio)) %>%
  mutate(Municipio=str_replace_all(Municipio,
                                   c(""="a",""="e",""="i",
                                     ""="o",""="u",''='A',
                                     ''='E',''='I',''='O',
                                     ''='U')))

consolidado=fijo_1 %>% 
  group_by(Municipio) %>% 
  spread(key=Municipio,value=Lineas) %>% 
  arrange(Fecha)

#Valores nulos
porcentaje=.2
#Municipios borrados: 210 (19.4% del total)
#sum(colMeans(is.na(consolidado))>porcentaje)
#(210*100)/1080
columnas_a_borrar=which(colMeans(is.na(consolidado))>porcentaje)
consolidado[,columnas_a_borrar]=NULL

#Imputacin de datos faltantes
consolidado_tel_fija=na_kalman(consolidado,model="auto.arima")
rm(list=setdiff(ls(),c("consolidado_tel_fija",'consolidado_int_fijo')))



